﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<SearchViewModel>" %>
<div id="searchForm" class="panel">
    <div class="innerPanel">
        <h2><span>Search <%=Html.ValidationMessage("Query")%></span></h2>
        
        <!-- SIMPLE SEARCH -->
        <fieldset class="simpleSearch" style="display: <%= (Model.AdvancedMode) ? "none" : "block" %>">
        <% using (Html.BeginForm<SearchController>(c => c.Search(null), FormMethod.Get)) %>
        <% { %>
            <p>
                <%=Html.TextBox("Query")%>
                <input type="submit" value="Search" />
                |
                <a class="mode" href="<%=Url.Action("Index", new { m = "a" })%>" onclick="$('#searchForm .simpleSearch').fadeOut('fast', function() { $('#searchForm .advancedSearch').fadeIn(); }); return false;">Advanced Search</a>
            </p>
            
            <%=Html.Hidden("Type", Model.Criteria.Type)%>
            <%=Html.Hidden("SortBy", Model.Criteria.SortBy)%>
            <p class="hint">e.g.: &ldquo;Bars in Manhattan, NY&rdquo;</p>
        <% } %>
        </fieldset>
        
        <!-- ADVANCED SEARCH -->
        <fieldset class="advancedSearch" style="display: <%= (Model.AdvancedMode) ? "block" : "none" %>">
        <% using (Html.BeginForm<SearchController>(c => c.Advanced(null), FormMethod.Get)) %>
        <% { %>
            <div class="fieldsA">
                <p>
                    Select an activity type and enter a location to constrain your search by....
                </p>
                <p>
                    <label for="ActivityTypeId">
                        Activity:
                        <%=Html.ValidationMessage("ActivityTypeId", "*", new { @class = "errorShort" })%>
                    </label>
                    <%=Html.DropDownList("ActivityTypeId", Model.SearchFields.ActivityTypes)%>
                </p>
            </div>
            <div class="fieldsB">
                <p>
                    <label for="StreetAddress">Address:</label>
                    <%=Html.TextBox("StreetAddress")%>
                </p>
                <p>
                    <label for="State">
                        State:
                        <%=Html.ValidationMessage("State", "*", new { @class = "errorShort" })%>
                    </label>
                    <%=Html.DropDownList("State", Model.SearchFields.States)%>
                    
                    <label for="City">
                        City:
                        <%=Html.ValidationMessage("City", "*", new { @class = "errorShort" })%>
                    </label>
                    <%=Html.TextBox("City", Model.SearchFields.City)%>
                </p>
                <p>
                    <label for="Zip">Zip:</label>
                    <%=Html.TextBox("Zip", null, new { size = 5, maxlength = 5 })%>
                    <label for="Radius">Miles:</label>
                    <%=Html.DropDownList("Radius", Model.SearchFields.Miles) %>
                </p>
            </div>
            <%=Html.Hidden("Type", Model.Criteria.Type)%>
            <%=Html.Hidden("SortBy", Model.Criteria.SortBy)%>
            <input type="submit" value="Search" />
            <a class="mode" href="<%=Url.Action("Index", new { m = "n" })%>" onclick="$('#searchForm .advancedSearch').fadeOut('fast', function() { $('#searchForm .simpleSearch').fadeIn(); $('input[type=text]:visible').focus(); }); return false;">Simple Search</a>
        <% } %>
        </fieldset>
    </div>
</div>